import numpy as np
from matplotlib import pyplot as plt
plt.ion()
from alt_cosine import altcos, EUV_conductance

szas = np.arange(-1,130,0.1)
altcosvals = altcos(szas)

moenhall, moenped = EUV_conductance(szas,F107=100)

fig,axes = plt.subplots(2,1,figsize=(5,6),sharex=True)
ax = axes[0]
ax.plot(szas,np.cos(np.deg2rad(szas)),label='cos (assumes flat earth)',color='gray',linestyle='--')
ax.plot(szas,altcosvals,label='altcos (assumes round earth)',color='k')
ax.legend()
ax.axhline(0,color='k',linestyle=':')
#ax.set_title("altcos")

ax = axes[1]
ax.plot(szas,moenhall,label="Hall")
ax.plot(szas,moenped,label="Ped")
ax.set_ylabel("Conductance [mho]")
ax.set_xlabel("SZA [deg]")
ax.legend()
ax.set_title("Moen & Brekke EUV conductances with altcos")
ax.set_xticks([0,15,30,45,60,75,90,105,120])

plt.tight_layout()

